/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.browser;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.DestinationPanel;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.BrowserNode;
import ibm.nways.jdm.browser.BrowserQuery;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.MultiLineLabel;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.eui.TwoColumnLayout;
import ibm.nways.jdm.eui.generator.Correspondence;
import ibm.nways.jdm.mib.MibAccess;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class BrowserPanel
extends Panel
implements DestinationPanel,
ActionListener,
EuiGridListener {
    private static final int NONE = 0;
    private static final int TABLE = 1;
    private static final int SCALAR = 2;
    private static final int ENTRY = 3;
    private static final String PROPNAME = "BrowserChild.browser.jdm.nways.ibm";
    private static final String SERVNAME = "BrowserService.browser.jdm.nways.ibm";
    private int displayed = 0;
    private BrowserQuery service;
    private MyScrollPane displayPane = new MyScrollPane();
    private MyLabel displayHeading;
    private Panel displayArea = new Panel();
    private Panel displayPanel = new MyPanel();
    private Panel displayButtons = new Panel();
    private Button displayApplyButton;
    private Button displayRefreshButton;
    private Button displayCancelButton;
    private MyScrollPane editPane = new MyScrollPane();
    private MyLabel editHeading;
    private Panel editArea = new Panel();
    private Panel editPanel = new MyPanel();
    private Panel editButtons = new Panel();
    private Button editApplyButton;
    private Button editRefreshButton;
    private Button editCancelButton;
    private Object context;
    private NavigationContext navContext;
    private RemoteModel model;
    private BrowserApplet browser;
    private BrowserNode item;
    private BrowserNode entryItem;
    private SnmpContextModel snmpmodel;
    Class widgetClass;
    JDMInput valueValue;
    EuiGrid table;
    int numcolumns;
    String[] mIndexes;
    int[] mTypes;
    StringBuffer columnHeadings = new StringBuffer();
    Vector columnOIs = new Vector();
    Vector columnTypes = new Vector();
    Vector columnNodes = new Vector();
    Vector columnWidgets = new Vector();
    protected BrowserTable tableData;
    protected TableColumns tableColumns;
    CardLayout manager = new CardLayout();
    private Vector s;
    private int selectedRow;
    private ResourceBundle myResources;

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public void setNavContext(NavigationContext navigationContext) {
        this.navContext = navigationContext;
    }

    public NavigationContext getNavContext() {
        return this.navContext;
    }

    public RemoteModel getModel() {
        return this.model;
    }

    public void setModel(RemoteModel remoteModel) {
        this.model = remoteModel;
    }

    public Component getComponent() {
        return this;
    }

    public void setBrowser(BrowserApplet browserApplet) {
        this.browser = browserApplet;
    }

    public BrowserApplet getBrowser() {
        return this.browser;
    }

    public String getDestinationTitle() {
        return "Mib Browser";
    }

    public void initDestPanel() {
        this.initialize();
    }

    public BrowserPanel() {
        this.setLayout(this.manager);
        this.item = null;
        this.entryItem = null;
    }

    protected void initialize() {
        this.snmpmodel = (SnmpContextModel)this.model;
        NavigationContext navigationContext = this.getNavContext();
        this.item = (BrowserNode)navigationContext.get(PROPNAME);
        this.service = (BrowserQuery)navigationContext.get(SERVNAME);
        this.displayed = this.item.type == 12 ? 1 : 2;
        this.displayApplyButton = new Button(this.getNLSString("applyButton"));
        this.displayApplyButton.setForeground(SystemColor.controlText);
        this.displayApplyButton.setBackground(SystemColor.control);
        this.displayApplyButton.setName("apply");
        this.displayApplyButton.addActionListener(this);
        this.displayRefreshButton = new Button(this.getNLSString("refreshButton"));
        this.displayRefreshButton.setForeground(SystemColor.controlText);
        this.displayRefreshButton.setBackground(SystemColor.control);
        this.displayRefreshButton.setName("refresh");
        this.displayRefreshButton.addActionListener(this);
        this.editApplyButton = new Button(this.getNLSString("applyButton"));
        this.editApplyButton.setForeground(SystemColor.controlText);
        this.editApplyButton.setBackground(SystemColor.control);
        this.editApplyButton.setName("apply");
        this.editApplyButton.addActionListener(this);
        this.editRefreshButton = new Button(this.getNLSString("refreshButton"));
        this.editRefreshButton.setForeground(SystemColor.controlText);
        this.editRefreshButton.setBackground(SystemColor.control);
        this.editRefreshButton.setName("refresh");
        this.editRefreshButton.addActionListener(this);
        this.editCancelButton = new Button(this.getNLSString("cancelButton"));
        this.editCancelButton.setForeground(SystemColor.controlText);
        this.editCancelButton.setBackground(SystemColor.control);
        this.editCancelButton.setName("cancel");
        this.editCancelButton.addActionListener(this);
        this.buildDisplayArea();
        if (this.displayed == 1) {
            this.buildEditArea();
        }
        this.add("display", this.displayArea);
        this.add("edit", this.editArea);
    }

    private void buildDisplayArea() {
        this.displayArea.setLayout(new BorderLayout());
        this.displayPanel.setLayout(new TwoColumnLayout());
        this.displayHeading = new MyLabel(this.item.getName());
        this.displayHeading.setForeground(JmaColors.textText);
        this.displayButtons.setLayout(new FlowLayout());
        if (this.item.access == 4 || this.item.access == 3) {
            this.displayButtons.add(this.displayApplyButton);
        }
        this.displayButtons.add(this.displayRefreshButton);
        Label label = new Label(this.getNLSString("oiLabel"));
        Label label2 = new Label(this.getNLSString("descLabel"));
        Label label3 = new Label(this.getNLSString("typeLabel"));
        Label label4 = new Label(this.getNLSString("accessLabel"));
        Label label5 = new Label(this.getNLSString("valueLabel"));
        Label label6 = new Label(this.item.oid.toString());
        MultiLineLabel multiLineLabel = new MultiLineLabel(this.item.getDescription());
        Label label7 = new Label(MibType.valToString((int)this.item.type));
        Label label8 = new Label(MibAccess.toString((int)this.item.access));
        label.setForeground(JmaColors.textText);
        label2.setForeground(JmaColors.textText);
        label3.setForeground(JmaColors.textText);
        label4.setForeground(JmaColors.textText);
        label5.setForeground(JmaColors.textText);
        label6.setForeground(JmaColors.textText);
        label7.setForeground(JmaColors.textText);
        label8.setForeground(JmaColors.textText);
        if (this.item.type == 12) {
            this.displayPanel.add(label);
            this.displayPanel.add(label6);
            this.displayPanel.add(label2);
            this.displayPanel.add(multiLineLabel);
            this.displayPanel.add(label3);
            this.displayPanel.add(label7);
            this.displayPanel.add(label5);
        } else {
            this.displayPanel.add(label);
            this.displayPanel.add(label6);
            this.displayPanel.add(label2);
            this.displayPanel.add(multiLineLabel);
            this.displayPanel.add(label3);
            this.displayPanel.add(label7);
            this.displayPanel.add(label4);
            this.displayPanel.add(label8);
            this.displayPanel.add(label5);
            try {
                this.widgetClass = Class.forName("ibm.nways.jdm.eui." + Correspondence.euiClass((int)this.item.type, (int)this.item.access));
                this.valueValue = (JDMInput)this.widgetClass.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.displayPanel.add((Component)((Object)this.valueValue));
        }
        if (this.item.type == 12) {
            this.layoutTable();
            this.table.refresh();
            this.displayMsg(this.getNLSString("endResetMsg"));
        } else {
            this.refresh();
        }
        this.displayPane.setInterior(this.displayPanel);
        this.displayArea.add("North", this.displayHeading);
        this.displayArea.add("Center", this.displayPane);
        this.displayArea.add("South", this.displayButtons);
        this.displayArea.doLayout();
    }

    private void buildEditArea() {
        boolean bl = false;
        this.editArea.setLayout(new BorderLayout());
        this.editPanel.setLayout(new TwoColumnLayout());
        this.editHeading = new MyLabel(this.entryItem.getName());
        this.editHeading.setForeground(JmaColors.textText);
        int n = 0;
        while (n < this.numcolumns) {
            BrowserNode browserNode = (BrowserNode)this.columnNodes.elementAt(n);
            if (browserNode.access == 4 || browserNode.access == 3) {
                bl = true;
            }
            ++n;
        }
        this.editButtons.setLayout(new FlowLayout());
        if (bl) {
            this.editButtons.add(this.editApplyButton);
        }
        this.editButtons.add(this.editRefreshButton);
        this.editButtons.add(this.editCancelButton);
        this.buildEditPanel();
        this.editPane.setInterior(this.editPanel);
        this.editArea.add("North", this.editHeading);
        this.editArea.add("Center", this.editPane);
        this.editArea.add("South", this.editButtons);
    }

    private void layoutTable() {
        try {
            if (this.item.type == 12) {
                if (this.item.children != null && this.item.children.size() == 1) {
                    Enumeration enumeration = this.item.children.elements();
                    OID oID = (OID)enumeration.nextElement();
                    this.entryItem = this.service.getNode(oID.toString());
                    if (this.entryItem.indexList != null) {
                        int n;
                        Object object;
                        Object object2;
                        int n2 = 0;
                        Object[] objectArray = new Object[1];
                        int n3 = this.entryItem.children.size();
                        this.mIndexes = new String[this.entryItem.indexList.size()];
                        this.mTypes = new int[this.entryItem.indexList.size()];
                        n2 = 0;
                        while (n2 < this.entryItem.indexList.size()) {
                            object2 = (OID)this.entryItem.indexList.elementAt(n2);
                            if (!this.entryItem.children.contains(object2)) {
                                ++n3;
                            }
                            ++n2;
                        }
                        object2 = new BrowserNode[n3];
                        TableColumn[] tableColumnArray = new TableColumn[n3];
                        n2 = 0;
                        while (n2 < this.entryItem.indexList.size()) {
                            object = (OID)this.entryItem.indexList.elementAt(n2);
                            objectArray[0] = new Integer(n3 - n2);
                            this.displayMsg(MessageFormat.format(this.getNLSString("metadataStart"), objectArray));
                            object2[n2] = this.service.getNode(((OID)object).toString());
                            n = this.typeToInt(object2[n2].type);
                            this.mIndexes[n2] = object2[n2].oid.toString();
                            this.mTypes[n2] = n == -8 && object2[n2].fixedLen > 0 ? object2[n2].fixedLen : n;
                            ++n2;
                        }
                        object = this.entryItem.children.elements();
                        while (object.hasMoreElements()) {
                            OID oID2 = (OID)object.nextElement();
                            if (this.entryItem.indexList.contains(oID2)) continue;
                            objectArray[0] = new Integer(n3 - n2);
                            this.displayMsg(MessageFormat.format(this.getNLSString("metadataStart"), objectArray));
                            object2[n2] = this.service.getNode(oID2.toString());
                            ++n2;
                        }
                        this.displayMsg(this.getNLSString("metadataEnd"));
                        this.displayMsg(this.getNLSString("sortStart"));
                        BrowserNode.QuickSort(object2, 0, n3 - 1);
                        this.displayMsg(this.getNLSString("sortEnd"));
                        n2 = 0;
                        while (n2 < n3) {
                            n = this.entryItem.indexList.contains(object2[n2].oid) ? 1 : 0;
                            tableColumnArray[n2] = new TableColumn(object2[n2].oid.toString(), object2[n2].getName(), object2[n2].type, n != 0);
                            this.columnNodes.addElement(object2[n2]);
                            ++this.numcolumns;
                            ++n2;
                        }
                        this.tableColumns = new TableColumns(tableColumnArray);
                        this.tableData = new BrowserTable(this.snmpmodel, this.tableColumns, this.mIndexes, this.mTypes);
                        this.table = new EuiGrid(this.tableData, this.tableColumns, false);
                        this.table.addRows(5);
                        this.table.addEuiGridListener(this);
                        this.displayPanel.add(this.table);
                        this.displayPanel.add(new Label(""));
                        Label label = new Label(this.getNLSString("instructionLabel"));
                        label.setForeground(JmaColors.textText);
                        this.displayPanel.add(label);
                        return;
                    }
                    System.err.println("Error: No indexes for table entry");
                    return;
                }
                System.err.println("Error: Improper number of children for table");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildEditPanel() {
        int n = 0;
        while (n < this.numcolumns) {
            JDMInput jDMInput = null;
            BrowserNode browserNode = (BrowserNode)this.columnNodes.elementAt(n);
            if (browserNode.type != 12) {
                try {
                    this.widgetClass = Class.forName("ibm.nways.jdm.eui." + Correspondence.euiClass((int)browserNode.type, (int)browserNode.access));
                    jDMInput = (JDMInput)this.widgetClass.newInstance();
                    this.columnWidgets.addElement(jDMInput);
                    Label label = new Label(browserNode.getName());
                    label.setForeground(JmaColors.textText);
                    this.editPanel.add(label);
                    this.editPanel.add((Component)((Object)jDMInput));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    private void loadEditPanel(ModelInfo modelInfo) {
        if (modelInfo != null) {
            int n = 0;
            Enumeration enumeration = this.tableColumns.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = (TableColumn)enumeration.nextElement();
                Serializable serializable = modelInfo.get((String)tableColumn.getIdentifier());
                JDMInput jDMInput = (JDMInput)this.columnWidgets.elementAt(n);
                int n2 = tableColumn.getType();
                if (serializable != null) {
                    if (serializable instanceof SpecialValue) {
                        jDMInput.setValue(serializable.toString());
                    } else if (serializable instanceof OctetString && n2 == 5) {
                        jDMInput.setValue(((OctetString)serializable).toDisplayString());
                    } else {
                        jDMInput.setValue(serializable);
                    }
                }
                ++n;
            }
        }
        this.editPanel.doLayout();
    }

    private void setTableRow(int n) {
        Object object;
        String string;
        Object object2;
        Object object3;
        ModelInfo modelInfo = (ModelInfo)this.tableData.elementAt(this.selectedRow);
        int n2 = 0;
        ModelInfo modelInfo2 = new ModelInfo();
        Enumeration enumeration = this.tableColumns.getColumns();
        while (enumeration.hasMoreElements()) {
            object3 = (TableColumn)enumeration.nextElement();
            object2 = (BrowserNode)this.columnNodes.elementAt(n2);
            if (MibAccess.allowsWrite((int)((BrowserNode)object2).access)) {
                string = (String)((TableColumn)object3).getIdentifier();
                object = (JDMInput)this.columnWidgets.elementAt(n2);
                Serializable serializable = (Serializable)object.getValue();
                modelInfo2.add(string, serializable);
            }
            ++n2;
        }
        object3 = this.tableData.setRow(modelInfo2);
        object2 = ((ModelInfo)object3).getItemIds();
        while (object2.hasMoreElements()) {
            string = (String)object2.nextElement();
            object = ((ModelInfo)object3).get(string);
            modelInfo.add(string, (Serializable)object);
        }
        this.loadEditPanel(modelInfo);
    }

    public void refresh() {
        this.displayMsg(this.getNLSString("startResetMsg"));
        switch (this.displayed) {
            case 1: {
                this.tableData.invalidate();
                this.table.refresh();
                break;
            }
            case 2: {
                try {
                    Serializable serializable = this.snmpmodel.get(String.valueOf(this.item.oid.toString()) + ".0");
                    this.valueValue.setValue(serializable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 3: {
                this.tableData.invalidate();
                this.loadEditPanel((ModelInfo)this.tableData.elementAt(this.selectedRow));
                break;
            }
            default: {
                System.err.println("Bad state encountered in reset()");
            }
        }
        this.displayMsg(this.getNLSString("endResetMsg"));
    }

    private void apply() {
        this.displayMsg(this.getNLSString("startApplyMsg"));
        switch (this.displayed) {
            case 2: {
                Serializable serializable;
                if (this.valueValue == null) break;
                try {
                    serializable = (Serializable)this.valueValue.getValue();
                    serializable = this.snmpmodel.set(String.valueOf(this.item.oid.toString()) + ".0", serializable);
                    this.valueValue.setValue(serializable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.item.oid.toString().equals("1.3.6.1.2.1.1.6") || !this.valueValue.toString().equals("Do not go to Z'ha'dum, or you will die.")) break;
                serializable = new Label(this.getNLSString("devLabel"));
                MultiLineLabel multiLineLabel = new MultiLineLabel();
                multiLineLabel.setText("Glenn Aikens\nWade Allen\nLucy Barnhill\nJoan Bellinghausen\nAnita Choy\nShawn Clymer\nDale Compliment\nRichard Franck\nMike Gering\nJason Herr\nDan Lemon\nRobert Nielsen\nKevin Ortega\nTom Prorock\nPaul Reder\nBill Reed\nDoug Willenborg\nMartha Yanez\nMark Zelek");
                this.displayPanel.add((Component)serializable);
                this.displayPanel.add(multiLineLabel);
                this.displayPanel.doLayout();
                break;
            }
            case 3: {
                this.setTableRow(this.selectedRow);
                break;
            }
            default: {
                System.err.println("Bad state encountered in apply()");
            }
            case 1: 
        }
        this.displayMsg(this.getNLSString("endApplyMsg"));
    }

    private void cancel() {
        switch (this.displayed) {
            case 3: {
                this.displayed = 1;
                this.table.deselectAllRows(false);
                this.manager.show(this, "display");
                return;
            }
            default: {
                System.err.println("Bad state encountered in cancel()");
            }
            case 1: 
            case 2: 
        }
    }

    private int typeToInt(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return -2;
            }
            case 2: {
                return -4;
            }
            case 3: {
                return -1;
            }
            case 4: {
                return -6;
            }
            case 5: {
                return -8;
            }
            case 6: {
                return -6;
            }
            case 7: {
                return -8;
            }
            case 8: {
                return -7;
            }
            case 9: {
                return -8;
            }
            case 10: {
                return -8;
            }
            case 11: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 13: {
                return -5;
            }
            case 14: {
                return -8;
            }
            case 15: {
                return -3;
            }
        }
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button.getName().equals("apply")) {
            this.apply();
        }
        if (button.getName().equals("refresh")) {
            this.refresh();
        }
        if (button.getName().equals("cancel")) {
            this.cancel();
        }
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
        if (euiGridEvent.getType() == 2001) {
            this.displayed = 3;
            this.selectedRow = euiGridEvent.getRow();
            this.loadEditPanel((ModelInfo)this.tableData.elementAt(this.selectedRow));
            this.manager.show(this, "edit");
        }
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    private String getNLSString(String string) {
        try {
            this.myResources = ResourceBundle.getBundle("ibm.nways.jdm.browser.BrowserPanelResources", Locale.getDefault());
            return this.myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    final /* synthetic */ String access$0(String string) {
        return this.getNLSString(string);
    }

    class MyScrollPane
    extends ScrollPane {
        public void setInterior(Panel panel) {
            super.addImpl(panel, null, 0);
        }

        MyScrollPane() {
            BrowserPanel.this = BrowserPanel.this;
        }
    }

    class MyPanel
    extends Panel {
        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }

        MyPanel() {
            BrowserPanel.this = BrowserPanel.this;
        }
    }

    class MyLabel
    extends Label {
        public MyLabel(String string) {
            super(string);
            BrowserPanel.this = BrowserPanel.this;
            Font font = new Font("SansSerif", 2, 24);
            this.setFont(font);
        }
    }

    public class BrowserTable
    extends Table {
        SnmpContextModel model;
        String[] mIndexes;
        int[] mTypes;
        Vector columnOIs;
        Vector columnsToTranslate = new Vector();
        int i;

        public BrowserTable(SnmpContextModel snmpContextModel, TableColumns tableColumns, String[] stringArray, int[] nArray) {
            BrowserPanel.this = BrowserPanel.this;
            this.model = snmpContextModel;
            this.mIndexes = stringArray;
            this.mTypes = nArray;
            this.columnOIs = new Vector();
            this.i = 0;
            Enumeration enumeration = tableColumns.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = (TableColumn)enumeration.nextElement();
                if (!tableColumn.getIsIndex()) {
                    this.columnOIs.addElement(tableColumn.getIdentifier());
                }
                if (tableColumn.getType() != 5) continue;
                this.columnsToTranslate.addElement(tableColumn);
            }
        }

        public ModelInfo setRow(ModelInfo modelInfo) {
            ModelInfo modelInfo2 = null;
            try {
                modelInfo2 = this.model.set(modelInfo, this.mIndexes, this.mTypes);
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return modelInfo2;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            ModelInfo modelInfo2 = null;
            BrowserPanel.this.displayMsg(BrowserPanel.this.access$0("startTableGetMsg"));
            try {
                modelInfo2 = this.model.getNext(modelInfo, this.columnOIs, this.mIndexes, this.mTypes);
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            BrowserPanel.this.displayMsg(BrowserPanel.this.access$0("endTableGetMsg"));
            if (modelInfo2 != null) {
                int n = 0;
                while (n < this.columnsToTranslate.size()) {
                    TableColumn tableColumn = (TableColumn)this.columnsToTranslate.elementAt(n);
                    Serializable serializable = modelInfo2.get((String)tableColumn.getIdentifier());
                    if (serializable instanceof OctetString && tableColumn.getType() == 5) {
                        modelInfo2.add((String)tableColumn.getIdentifier(), (Serializable)((Object)((OctetString)serializable).toDisplayString()));
                    }
                    ++n;
                }
            }
            return modelInfo2;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            ModelInfo modelInfo2 = null;
            int n = 0;
            while (n < this.columnOIs.size()) {
                String string = (String)this.columnOIs.elementAt(n);
                if (modelInfo.get(string) == null) {
                    modelInfo.add(string);
                }
                ++n;
            }
            BrowserPanel.this.displayMsg(BrowserPanel.this.access$0("startTableGetMsg"));
            try {
                modelInfo2 = this.model.get(modelInfo, this.mIndexes, this.mTypes);
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            BrowserPanel.this.displayMsg(BrowserPanel.this.access$0("endTableGetMsg"));
            if (modelInfo2 != null) {
                int n2 = 0;
                while (n2 < this.columnsToTranslate.size()) {
                    TableColumn tableColumn = (TableColumn)this.columnsToTranslate.elementAt(n2);
                    Serializable serializable = modelInfo2.get((String)tableColumn.getIdentifier());
                    if (serializable instanceof OctetString && tableColumn.getType() == 5) {
                        modelInfo2.add((String)tableColumn.getIdentifier(), (Serializable)((Object)((OctetString)serializable).toDisplayString()));
                    }
                    ++n2;
                }
            }
            return modelInfo2;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
        }
    }
}

